package com.beiming.basic.chat.api.dto.response;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description 平台联系人数据项
 * @Author blake
 * @Date 2020/5/13 4:19 下午
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PlatformContactResDTO implements Serializable {

  private static final long serialVersionUID = 1637712804510697246L;

  private Long id;

  // 平台聊天室标记，随机生成字符串
  private String roomTag;

  // 消息发送人id
  private String senderId;

  // 消息接收人id
  private String receiverId;

  // 当前对话是否有效：1=有效,0=无效
  private Integer active;

  // 状态 0 正常 1 删除
  private Integer status;

  private String createUser;

  private String updateUser;

  private Date createTime;

  private Date updateTime;

}
