package com.beiming.basic.chat.api.dto.response;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import com.alibaba.fastjson.JSONObject;
import com.beiming.basic.chat.api.enums.RoomTypeEnums;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 房间信息dto
 * 
 * @author lb
 *
 */
@Data
@NoArgsConstructor
public class RoomResDTO implements Serializable {

  private static final long serialVersionUID = 5109173885992146438L;

  /**
   * 房间id
   */
  private String roomId;
  /**
   * 混流id
   */
  private String streamId;

  /**
   * 混流后播放地址
   */
  private String playUrl;

  /**
   * 房间开始时间
   */
  private Date startTime;

  /**
   * 房间结束时间
   */
  private Date endTime;

  /**
   * 房间类型
   */
  private RoomTypeEnums roomType;

  /**
   * 房间成员信息
   */
  private List<MemberResDTO> members;
  /**
   * 视频信息
   * startTime 视频开始时间 --也是treemap的key
   * endTime 视频结束时间
   * playUrl 播放地址
   */
  private List<JSONObject> videoInfos;
}
