package com.beiming.basic.chat.api.dto.response;

import java.io.Serializable;
import lombok.Data;
import lombok.NoArgsConstructor;
/**
 * 分段情绪占比
 * @author ljf
 *
 */
@Data
@NoArgsConstructor
public class SegmentedEmotionalRecognitionResDTO implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = -2413820397508186383L;

  /**
   * 主键
   */
  private Integer id;

  /**
   * 房间号
   */
  private String roomId;

  /**
   * 成员id
   */
  private String memberId;
  /**
   * 成员id
   */
  private String memberName;
  
  private String prefix;

  /**
   * 平静
   */
  private Integer neutral;

  /**
   * 悲伤
   */
  private Integer sadness;

  /**
   * 厌恶
   */
  private Integer disgust;

  /**
   * 愤怒
   */
  private Integer anger;

  /**
   * 惊奇
   */
  private Integer surprise;

  /**
   * 恐惧
   */
  private Integer fear;

  /**
   * 高兴
   */
  private Integer happiness;

  /**
   * 分段时间开始时间戳
   */
  private Long segmentedTime;

  public SegmentedEmotionalRecognitionResDTO(String roomId, String memberId, String memberName,
      Integer neutral, Integer sadness, Integer disgust, Integer anger,
      Integer surprise, Integer fear, Integer happiness) {
    super();
    this.roomId = roomId;
    this.memberId = memberId;
    this.memberName = memberName;
    this.neutral = neutral;
    this.sadness = sadness;
    this.disgust = disgust;
    this.anger = anger;
    this.surprise = surprise;
    this.fear = fear;
    this.happiness = happiness;
  }
  
  public static SegmentedEmotionalRecognitionResDTO initBean(String roomId, String memberId, String memberName) {
    SegmentedEmotionalRecognitionResDTO newBean = new SegmentedEmotionalRecognitionResDTO(roomId, memberId, memberName, 0, 0, 0, 0, 0, 0, 0);
    return newBean;
  }
  
}
