package com.beiming.basic.chat.api.sm4util;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.beiming.basic.chat.api.annotation.EncryptDecryptField;
import com.beiming.basic.chat.api.dto.ParamsDto;
import com.beiming.basic.chat.api.openfeign.EncryptFeignClient;
import com.beiming.framework.enums.APIResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;

/**
 * @author HUAWEI
 * @date 2022/08/23
 */
@Component
public class EncryptDecryptUtil {


  @Resource
  private EncryptFeignClient encryptFeignClient;

  /**
   * 判断数据是否已经加密过,避免数据重复加密。
   *
   * @param source 数据
   * @return true 未加密 false 已经加密
   */
  private static Boolean checkIsEncrypt(String source) {
    return source.contains("xy_db_encrypt_");
  }

  /**
   * 数据加密
   *
   * @param declaredFields paramsObject所声明的字段
   * @param paramsObject   mapper中paramsType的实例
   * @return T
   * @throws IllegalAccessException 字段不可访问异常
   */
  public <T> T encrypt(Field[] declaredFields, T paramsObject) throws IllegalAccessException {
    for (Field field : declaredFields) {
      //取出所有被EncryptDecryptField注解的字段
      EncryptDecryptField sensitiveField = field.getAnnotation(EncryptDecryptField.class);
      if (!Objects.isNull(sensitiveField)) {
        field.setAccessible(true);
        Object object = field.get(paramsObject);

        //暂时只实现String类型的加密
        if (object instanceof String) {
          String value = (String) object;
          String key = field.getName();
          //加密
          if (StringUtils.isNotEmpty(value) && !checkIsEncrypt(value)) {
            //xy_db_encrypt_ 加密统一增加前缀字符串 用于避免数据重复加密标识位
            // field.set(paramsObject, "xy_db_encrypt_" + SM4Utils.encryptDataCbc(value));
            ParamsDto paramsDto = new ParamsDto();
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            String s = Base64Utils.encodeToString(bytes);
            paramsDto.getObj().put(key, s);
            JSONObject resVo = encryptFeignClient.encryption(paramsDto);
            AssertUtils
                .assertTrue(1000 == resVo.getInteger("code"), APIResultCodeEnums.ILLEGAL_PARAMETER,
                    "加密结果失败");
            JSONObject obj = JSON
                .parseObject(JSON.toJSONString(resVo.get("data")), JSONObject.class);
            String encryptValue = obj.get(key).toString();
            field.set(paramsObject, "xy_db_encrypt_" + encryptValue);
          } else {
            field.set(paramsObject, value);
          }
        }
      }
    }
    return paramsObject;
  }

  /**
   * 数据解密
   *
   * @param result resultType的实例
   * @return T
   * @throws IllegalAccessException 字段不可访问异常
   */
  public <T> T decrypt(T result) throws IllegalAccessException {
    //取出resultType的类
    Class<?> resultClass = result.getClass();
    Field[] declaredFields = resultClass.getDeclaredFields();
    for (Field field : declaredFields) {
      //取出所有被EncryptDecryptField注解的字段
      EncryptDecryptField sensitiveField = field.getAnnotation(EncryptDecryptField.class);
      if (!Objects.isNull(sensitiveField)) {
        field.setAccessible(true);
        Object object = field.get(result);
        //只支持String的解密
        if (object instanceof String) {
          String value = (String) object;
          String key = field.getName();
          if (StringUtils.isNotEmpty(value) && checkIsEncrypt(value)) {
            //去除加密字符串的前缀 xy_db_encrypt_
            // field.set(result, SM4Utils.decryptDataCbc(value.substring(14, value.length())));
            String data = value.substring(14);
            ParamsDto paramsDto = new ParamsDto();
            paramsDto.getObj().put(key, data);
            System.out.println("====解密参数====" + paramsDto);
            JSONObject resVo = encryptFeignClient.decryption(paramsDto);
            AssertUtils
                .assertTrue(1000 == resVo.getInteger("code"), APIResultCodeEnums.ILLEGAL_PARAMETER,
                    "解密结果失败");
            JSONObject obj = JSON
                .parseObject(JSON.toJSONString(resVo.get("data")), JSONObject.class);
            String baseValue = obj.get(key).toString();
            byte[] bytes = Base64Utils.decodeFromString(baseValue);
            String decryptValue = new String(bytes, StandardCharsets.UTF_8);
            field.set(result, decryptValue);
          } else {
            field.set(result, value);
          }
        }
      }
    }
    return result;
  }
}