/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.basic.chat.api.dto.request;

import com.beiming.basic.chat.api.dto.request.SendMessageReqDTO;
import com.beiming.basic.chat.api.enums.MessageResourceEnums;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

public class SendTextMessageReqDTO
extends SendMessageReqDTO {
    private static final long serialVersionUID = -1298142885154912794L;
    @NotBlank(message="{send.content.not.blank}")
    @Size(max=1024, message="{send.content.too.long}")
    private @NotBlank(message="{send.content.not.blank}") @Size(max=1024, message="{send.content.too.long}") String messageContent;
    private MessageResourceEnums messageResource;

    public SendTextMessageReqDTO(String roomId, String senderId, String messageContent, MessageResourceEnums ... messageResourceEnums) {
        super(roomId, senderId);
        this.messageContent = messageContent;
        if (messageResourceEnums != null && messageResourceEnums.length > 0) {
            this.messageResource = messageResourceEnums[0];
        }
    }

    public SendTextMessageReqDTO(String roomId, String senderId, String receiverId, String messageContent, MessageResourceEnums ... messageResourceEnums) {
        super(roomId, senderId, receiverId);
        this.messageContent = messageContent;
        if (messageResourceEnums != null && messageResourceEnums.length > 0) {
            this.messageResource = messageResourceEnums[0];
        }
    }

    public String getMessageContent() {
        return this.messageContent;
    }

    public MessageResourceEnums getMessageResource() {
        return this.messageResource;
    }

    public void setMessageContent(String messageContent) {
        this.messageContent = messageContent;
    }

    public void setMessageResource(MessageResourceEnums messageResource) {
        this.messageResource = messageResource;
    }

    @Override
    public String toString() {
        return "SendTextMessageReqDTO(messageContent=" + this.getMessageContent() + ", messageResource=" + (Object)((Object)this.getMessageResource()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendTextMessageReqDTO)) {
            return false;
        }
        SendTextMessageReqDTO other = (SendTextMessageReqDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$messageContent = this.getMessageContent();
        String other$messageContent = other.getMessageContent();
        if (this$messageContent == null ? other$messageContent != null : !this$messageContent.equals(other$messageContent)) {
            return false;
        }
        MessageResourceEnums this$messageResource = this.getMessageResource();
        MessageResourceEnums other$messageResource = other.getMessageResource();
        return !(this$messageResource == null ? other$messageResource != null : !((Object)((Object)this$messageResource)).equals((Object)other$messageResource));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SendTextMessageReqDTO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $messageContent = this.getMessageContent();
        result = result * 59 + ($messageContent == null ? 43 : $messageContent.hashCode());
        MessageResourceEnums $messageResource = this.getMessageResource();
        result = result * 59 + ($messageResource == null ? 43 : ((Object)((Object)$messageResource)).hashCode());
        return result;
    }

    public SendTextMessageReqDTO() {
    }
}

