package com.beiming.basic.chat.api.dto.request;

import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class ChatRecordReqDTO implements Serializable {

  private static final long serialVersionUID = -9110495118221215119L;

  // 当前用户id
  private Long userId;

  @NotNull(message = "案件id不允许为空")
  private Long lawCaseId;

  // 接收方id
  @NotNull(message = "接收用户id不允许为空")
  private Long receiverId;

  // 消息类型：IMG-图片，AUDIO-音频，FILE-常规文档
  private String messageType;

  // 搜索内容
  private String searchKey;

  // 当前页
  private Integer curPage;

  // 每页记录数
  private Integer pageSize;

  // 分页索引起始值
  private Integer pageIndex;

  // 发送用户id列表
  private List<Long> senderIds;

}
