package com.beiming.basic.chat.api.dto.request;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import com.beiming.basic.chat.api.ChatApiValidationMessage;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 房间dto
 * 
 * @author lb
 *
 */
@Data
@NoArgsConstructor
public class RoomMemberReqDTO implements Serializable {
  private static final long serialVersionUID = -6375101556895950910L;

  @NotBlank(message = ChatApiValidationMessage.ROOM_ID_NOT_BLANK)
  private String roomId;

  @NotBlank(message = ChatApiValidationMessage.MEMBER_ID_NOT_BLANK)
  private String memberId;

  public RoomMemberReqDTO(String roomId, String memberId) {
    super();
    this.roomId = roomId;
    this.memberId = memberId;
  }
}
