package com.beiming.basic.chat.api.dto.request;

import com.beiming.basic.chat.api.ChatApiValidationMessage;
import com.beiming.basic.chat.api.enums.MemberStatusEnums;
import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zhouxin
 * @since 2019/8/23
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UpdateMemberStatusReqDTO implements Serializable {

  /**
   *
   */
  private static final long serialVersionUID = 6632802651895910352L;
  @NotBlank(message = ChatApiValidationMessage.ROOM_ID_NOT_BLANK)
  private String roomId;
  @NotNull(message = ChatApiValidationMessage.MEMBER_ID_NOT_BLANK)
  private String[] memberIds;
  @NotNull(message = ChatApiValidationMessage.MEMBER_ID_NOT_BLANK)
  private MemberStatusEnums status;
}
