package com.beiming.basic.chat.api.dto.request;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import com.beiming.basic.chat.api.VersionApiValidationMessage;
import com.beiming.basic.chat.api.enums.CTypeEnums;
import lombok.Data;

@Data
public class VersionCheckReqDTO implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = -147336797768755420L;
  /**
   * 系统标识
   */
  @NotNull(message = VersionApiValidationMessage.CTYPE_NOT_BLANK)
  private CTypeEnums cType;
  /**
   * app版本号
   */
  @NotBlank(message = VersionApiValidationMessage.APPVERSION_NOT_BLANK)
  private String appVersion;
  /**
   * app名称
   */
  @NotBlank(message = VersionApiValidationMessage.APPNAME_NOT_BLANK)
  private String appName;
}
