package com.beiming.basic.chat.api;

import com.beiming.basic.chat.api.dto.request.ChatRecordReqDTO;
import com.beiming.basic.chat.api.dto.request.HistoryMessageListReqDTO;
import com.beiming.basic.chat.api.dto.request.ManualConsultChatRecordsReqDTO;
import com.beiming.basic.chat.api.dto.request.MinaRoomHistoryMessageReqDTO;
import com.beiming.basic.chat.api.dto.request.NewSendMessageReqDTO;
import com.beiming.basic.chat.api.dto.request.PlatformContactStatusReqDTO;
import com.beiming.basic.chat.api.dto.request.PlatformHistoryMsgReqDTO;
import com.beiming.basic.chat.api.dto.request.UnreadMsgReqDTO;
import com.beiming.basic.chat.api.dto.response.HistoryMessageListDTO;
import com.beiming.basic.chat.api.dto.response.HistoryMessageResDTO;
import com.beiming.basic.chat.api.dto.response.ManualConsultChatRecordResponseDTO;
import com.beiming.basic.chat.api.dto.response.MinaMessageListResponseDTO;
import com.beiming.basic.chat.api.dto.response.MinaRoomMessageListResponseDTO;
import com.beiming.framework.domain.DubboResult;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;

/**
 * @Auther: Administrator
 * @Date: 2019/4/4/004 15:29
 * @Description:
 */
public interface ChatRoomApi {

  /**
  * @Description: 保存聊天信息
  * @Param: [dto]
  * @return: com.beiming.framework.domain.DubboResult
  * @Author: XZY
  * @Date: 2019/4/8/008
  */
  DubboResult sendTextMessage(@Valid NewSendMessageReqDTO dto);
  /**
   * @Description: 获取历史聊天信息
   * @Param: [dto]
   * @return: com.beiming.framework.domain.DubboResult
   * @Author: XZY
   * @Date: 2019/4/8/008
   */
  DubboResult<HistoryMessageResDTO> getHisMessageList(HistoryMessageListReqDTO reqDTO,
      List<Long> personIds);


  DubboResult<MinaMessageListResponseDTO> getMinaMessageList(Long userId);


  DubboResult<MinaRoomMessageListResponseDTO> getMinaRoomMessageList(MinaRoomHistoryMessageReqDTO reqDTO);

  DubboResult<HistoryMessageResDTO> obtainUnreadMsgCount(UnreadMsgReqDTO arg);

  List<HistoryMessageListDTO> obtainChatRecords(ChatRecordReqDTO reqDTO);

  Long calculateNotes(ChatRecordReqDTO reqDTO);

  void saveVoiceFile(Long lawCaseId, String caseNo, String fileName, String fileType, String originUrl, String url);

  HistoryMessageResDTO determineIfUnreadMsg(Long lawCaseId, Long userId, Boolean isPlatform);

  DubboResult<HistoryMessageResDTO> queryLatestUnreadMsg(Long userId);

  /**
   * 平台聊天室消息列表
   */
  DubboResult<ArrayList<HistoryMessageListDTO>> listRecentContact(PlatformHistoryMsgReqDTO reqDTO, String roomTag);

  void handlePlatformContact(PlatformContactStatusReqDTO reqDTO);

  /**
   * 人工咨询聊天记录列表
   */
  ManualConsultChatRecordResponseDTO listManualConsultChatRecord(ManualConsultChatRecordsReqDTO reqDTO);

  /**
   * 平台聊天室：创建群聊
   */
  void createGroupChatWithRoomTagAssigned(String roomTag, String memberId);

  /**
   * 查询最后一条聊天记录
   */
  DubboResult<HistoryMessageListDTO> queryLastMessage(Long userId, Long otherSideUserId,
      Long lawCaseId);
}
