package com.beiming.basic.chat.api;

import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import com.beiming.basic.chat.api.dto.request.EmotionalRecognitionReqDTO;
import com.beiming.basic.chat.api.dto.response.EmotionalRecognitionResDTO;
import com.beiming.basic.chat.api.dto.response.EmotionalRecognitionStatisticsResDTO;
import com.beiming.framework.domain.DubboResult;

/**
 * 情绪识别相关API
 * @author ljf
 *
 */
@Valid
public interface EmotionalRecognitionApi {
  /**
   * 保存情绪识别结果数据
   * @param arg
   * @return
   */
  DubboResult<String> saveEmotionalRecognition(@Valid EmotionalRecognitionReqDTO arg);
  /**
   * <pre>
   * 查询房间内最新的一组情绪识别数据
   * 主要使用场景是实时视频
   * @param roomId
   */
  DubboResult<ArrayList<EmotionalRecognitionResDTO>> listNewestEmotionalRecognitionByRoomId(
      @Valid @NotBlank(message = ChatApiValidationMessage.ROOM_NUMBER_CANNOT_BE_EMPTY) String roomId);
  /**
   * 执行统计
   * @param roomId (此ID为转换后的字符串ID)
   * @return
   */
  DubboResult executeEmotionalRecognitionStatistics(
      @Valid @NotBlank(message = ChatApiValidationMessage.ROOM_NUMBER_CANNOT_BE_EMPTY) String roomId);

  /**
   * 根据房间ID(此ID为转换后的字符串ID)查询房间内情绪识别人员的分段数据,和详细数据
   * @param roomId
   * @return
   */
  DubboResult<ArrayList<EmotionalRecognitionStatisticsResDTO>> listEmotionalRecognitionStatisticsByRoomId(
      @Valid @NotBlank(message = ChatApiValidationMessage.ROOM_NUMBER_CANNOT_BE_EMPTY) String roomId);


}
