package com.beiming.basic.chat.api.dto.request;

import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class ManualConsultChatRecordsReqDTO implements Serializable {

  private static final long serialVersionUID = -2591536241304873431L;

  @NotNull(message = "receiver.id.cannot.be.null")
  private Long receiverId;

  @NotBlank(message = "room.tag.cannot.be.blank")
  private String roomTag;

  @NotNull(message = "当前页码不能为空。")
  @Min(value = 1, message = "当前页码必须大于0。")
  private Integer pageIndex;

  @NotNull(message = "每页的数量不能为空。")
  @Min(value = 1, message = "每页的数量必须大于0。")
  private Integer pageSize;

}
