package com.beiming.basic.chat.api.dto.request;

import com.beiming.basic.chat.api.ChatApiValidationMessage;
import com.beiming.basic.chat.api.constants.ChatApiConstant;
import com.beiming.basic.chat.api.enums.MessageResourceEnums;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
public class SendTextMessageReqDTO extends SendMessageReqDTO {

  private static final long serialVersionUID = -1298142885154912794L;

  /**
   * 消息内容
   */
  @NotBlank(message = ChatApiValidationMessage.SEND_CONTENT_NOT_BLANK)
  @Size(max = ChatApiConstant.MESSAGE_CONTENT_MAX_SIZE,
      message = ChatApiValidationMessage.SEND_CONTENT_TOO_LONG)
  private String messageContent;

  //  @NotEmpty(message = ChatApiValidationMessage.SEND_MESSAGE_RESOURCE_NOT_BLANK)
  private MessageResourceEnums messageResource;

  public SendTextMessageReqDTO(String roomId, String senderId, String messageContent,
      MessageResourceEnums... messageResourceEnums) {
    super(roomId, senderId);
    this.messageContent = messageContent;
    if (messageResourceEnums != null && messageResourceEnums.length > 0) {
      this.messageResource = messageResourceEnums[0];
    }
  }

  public SendTextMessageReqDTO(String roomId, String senderId, String receiverId,
      String messageContent, MessageResourceEnums... messageResourceEnums) {
    super(roomId, senderId, receiverId);
    this.messageContent = messageContent;
    if (messageResourceEnums != null && messageResourceEnums.length > 0) {
      this.messageResource = messageResourceEnums[0];
    }
  }
}
