package com.beiming.basic.message.api;

import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Service;
import com.beiming.basic.message.dto.request.AddSmsConfigDTO;
import com.beiming.basic.message.dto.request.AddSmsTemplateDTO;
import com.beiming.basic.message.dto.request.ConfigListRequestDTO;
import com.beiming.basic.message.dto.request.DelSmsConfigDTO;
import com.beiming.basic.message.dto.request.DelSmsTemplateDTO;
import com.beiming.basic.message.dto.request.ModSmsConfigDTO;
import com.beiming.basic.message.dto.request.ModSmsTemplateDTO;
import com.beiming.basic.message.dto.request.PushTemplateRequestDTO;
import com.beiming.basic.message.dto.request.TemplateListRequestDTO;
import com.beiming.basic.message.dto.response.ConfigResponseDTO;
import com.beiming.basic.message.dto.response.TemplateResponseDTO;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;

@Valid
@Service
public interface MessageConfigApi {
  /**
   * 新增短信配置
   * 逻辑控制系统标识唯一性
   * @param phone
   * @param message
   */
  public DubboResult<Boolean> addSmsConfig(@Valid AddSmsConfigDTO arg0);
  /**
   * 修改短信配置
   * @param phone
   * @param message
   */
  public DubboResult<Boolean> modSmsConfig(@Valid ModSmsConfigDTO arg0);
  /**
   * 删除短信配置(逻辑删除)
   * @param phone
   * @param message
   */
  public DubboResult<Boolean> delSmsConfig(@Valid DelSmsConfigDTO arg0);
  /**
   * 新增短信模板
   * 逻辑控制短信模板ID唯一性(全表)
   * @param arg0
   * @return 新增成功则响应模板ID
   */
  public DubboResult<Boolean> addSmsTemplate(@Valid AddSmsTemplateDTO arg0);
  /**
   * 修改短信模板
   * --不允许修改系统标识
   * @param arg0
   * @return 
   */
  public DubboResult<Boolean> modSmsTemplate(@Valid ModSmsTemplateDTO arg0);
  /**
   * 删除短信模板
   * @param arg0
   * @return 新增成功则响应模板ID
   */
  public DubboResult<Boolean> delSmsTemplate(@Valid DelSmsTemplateDTO arg0);
  /**
   * 同步短信到腾讯短信平台申请/修改/删除短信模板
   * 审核通过的短信模板是无法修改,所以再申请时先查询一下模板是否已经申请到腾讯,如果有则先申请删除再申请新增
   * @param arg0
   * @return 
   */
  public DubboResult<Boolean> pushSmsTemplate(@Valid PushTemplateRequestDTO arg0);
  /**
   * 分页查询模板
   * @param arg0
   * @return
   */
  public DubboResult<PageInfo<TemplateResponseDTO>> selectTemplatePageList(@Valid TemplateListRequestDTO arg0);
  /**
   * 分页查询短信配置
   * @param arg0
   * @return
   */
  public DubboResult<PageInfo<ConfigResponseDTO>> selectConfigPageList(@Valid ConfigListRequestDTO arg0);
  /**
   * 查询模板
   * @param arg0
   * @return
   */
  public DubboResult<ArrayList<TemplateResponseDTO>> selectTemplateList(@Valid TemplateListRequestDTO arg0);
  /**
   * 查询短信配置
   * @param arg0
   * @return
   */
  public DubboResult<ArrayList<ConfigResponseDTO>> selectConfigList(@Valid ConfigListRequestDTO arg0);
  
  public DubboResult<ConfigResponseDTO> selectConfigByPrimaryKey(@Valid @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL) Integer id);
  
  public DubboResult<TemplateResponseDTO> selectTemplateByPrimaryKey(@Valid @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL) Integer id);
}
