package com.beiming.basic.message.api;

import javax.validation.Valid;
import com.beiming.basic.message.dto.request.GetSmsCallBackRequestDTO;
import com.beiming.basic.message.dto.request.SendSmsRequestDTO;
import com.beiming.basic.message.dto.response.GetSmsCallBackResponseDTO;
import com.beiming.framework.domain.DubboResult;

@Valid
public interface MessageServiceApi {
  /**
   * 发送短信,通过全文发送短信
   * @param phone
   * @param message
   */
  public DubboResult<String> sendSMS(@Valid SendSmsRequestDTO arg0);
  /**
   * 拉取短信回复/回执
   * 默认拉取当前时间往前30分钟的最新一百条数据
   * 如果配置修改联系相关人员,获得准确的配置信息
   * @param arg0
   * @return
   */
  public DubboResult<GetSmsCallBackResponseDTO> smsCallBack(@Valid GetSmsCallBackRequestDTO arg0);
  /**
   * 发生短信,通过指定模版ID发送短信
   * 腾讯通道
   * @param arg0
   * @return
   */
//  public DubboResult<String> sendSMSWithTencent(@Valid SendSmsByTencentRequestDTO arg0);
}
