package com.beiming.basic.message.dto.request;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import com.beiming.basic.message.api.ValidationMessage;
import com.beiming.basic.message.enums.SmsChannalEnum;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;

@NoArgsConstructor
@AllArgsConstructor
public class AddSmsConfigDTO implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 6085697102299882669L;

  /**
   * 系统标识,全局唯一
   */
  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  private String sys;

  /**
   * 短信通道,华为和腾讯
   */
  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  private SmsChannalEnum channel;

  /**
   * 腾讯中为应用ID,华为中为username
   */
  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  private String appId;

  /**
   * 腾讯中为密码密钥,华为中为password
   */
  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  private String appKey;

  /**
   * 目前只有华为短信用到
   */
  private String domainName;
  /**
   * 华为短信为对应的签名ID,腾讯短信为签名名称
   */
  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  private String sign;
  
  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  private String signId;
  /**
   * 区域-只有华为有
   */
  private String regionId;
  /**
   *  腾讯云账号中的 secretId
   */
  private String secretId;
  /**
   * 腾讯云账号中的 secretKey
   */
  private String secretKey;
  /**
   * @return the 系统标识,全局唯一
   */
  public String getSys() {
    return sys;
  }

  /**
   * @param 系统标识,全局唯一 the sys to set
   */
  public void setSys(String sys) {
    this.sys = sys == null ? null : sys.trim();
  }

  /**
   * @return the 短信通道,华为和腾讯
   */
  public SmsChannalEnum getChannel() {
    return channel;
  }

  /**
   * @param 短信通道,华为和腾讯 the channel to set
   */
  public void setChannel(SmsChannalEnum channel) {
    this.channel = channel;
  }

  /**
   * @return the 腾讯中为应用ID,华为中为username
   */
  public String getAppId() {
    return appId;
  }

  /**
   * @param 腾讯中为应用ID,华为中为username the app_id to set
   */
  public void setAppId(String appId) {
    this.appId = appId == null ? null : appId.trim();
  }

  /**
   * @return the 腾讯中为密码密钥,华为中为password
   */
  public String getAppKey() {
    return appKey;
  }

  /**
   * @param 腾讯中为密码密钥,华为中为password the app_key to set
   */
  public void setAppKey(String appKey) {
    this.appKey = appKey == null ? null : appKey.trim();
  }

  /**
   * @return the 目前只有华为短信用到
   */
  public String getDomainName() {
    return domainName;
  }

  /**
   * @param 目前只有华为短信用到 the domain_Name to set
   */
  public void setDomainName(String domainName) {
    this.domainName = domainName == null ? null : domainName.trim();
  }

  /**
   * @return the 华为短信为对应的签名ID,腾讯短信为签名名称
   */
  public String getSign() {
    return sign;
  }

  /**
   * @param 华为短信为对应的签名ID,腾讯短信为签名名称 the sign to set
   */
  public void setSign(String sign) {
    this.sign = sign == null ? null : sign.trim();
  }

  public String getSignId() {
    return signId;
  }

  public void setSignId(String signId) {
    this.signId = signId;
  }

  public String getRegionId() {
    return regionId;
  }

  public void setRegionId(String regionId) {
    this.regionId = regionId;
  }

  public String getSecretId() {
    return secretId;
  }

  public void setSecretId(String secretId) {
    this.secretId = secretId;
  }

  public String getSecretKey() {
    return secretKey;
  }

  public void setSecretKey(String secretKey) {
    this.secretKey = secretKey;
  }
}
