package com.beiming.basic.message.dto.request;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import com.beiming.basic.message.api.ValidationMessage;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
@Data
@NoArgsConstructor
@AllArgsConstructor
public class AddSmsTemplateDTO implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = 1494218871149267505L;
  /**
   * 系统标识
   */
  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  private String sys;
  /**
   * 模板id
   */
  @Size(max = 50)
  private String templateId;

  /**
   * 模板名称
   */
  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  @Size(max = 50)
  private String templateName;

  /**
   * 模板内容
   */
  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  @Size(max = 1024)
  private String templateContext;
  /**
   * key的数组,根据出现在短信中的顺序出现
   */
//  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  @Size(max = 1024)
  private String keys;

}
