package com.beiming.basic.message.dto.request;

import java.io.Serializable;
import javax.validation.constraints.Max;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import com.beiming.basic.message.api.ValidationMessage;
import com.beiming.basic.message.common.ApiConst;
import com.beiming.basic.message.enums.SmsCallBackTypeEnum;
import lombok.Data;
@Data
public class GetSmsCallBackRequestDTO implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = -4170075517103636892L;
  @Pattern(regexp = ApiConst.REGEX_MOBILE_EXACT, message = ValidationMessage.MOBILE_PHONE_INCORRECT)
  @NotBlank(message = ValidationMessage.MOBILE_PHONE_INCORRECT)
  private String phone;
  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  private SmsCallBackTypeEnum type;
  /**
   * 开始时间戳(秒级)
   * 例如:1511125600
   * 不传取endTime-30分钟
   */
  private Long startTime;
  /**
   * 结束时间戳(秒级)
   * 不传取当前时间
   * 例如:1511841600
   */
  private Long endTime;
  /**
   * 拉取回复/回执的条数
   * 最大100,不传默认取30
   */
  @Max(100)
  private int maxNum;
}
