package com.beiming.basic.message.dto.request;

import javax.validation.constraints.NotNull;
import com.beiming.basic.message.api.ValidationMessage;
import com.beiming.basic.message.enums.SmsChannalEnum;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper = false)
@AllArgsConstructor
public class ModSmsConfigDTO extends AddSmsConfigDTO {

  /**
   * 
   */
  private static final long serialVersionUID = 7875576008849265043L;

  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  private Integer id;

  public ModSmsConfigDTO() {
    super();
  }

  public ModSmsConfigDTO(Integer id, String sys, SmsChannalEnum channel, String appId,
      String appKey, String domainName, String sign, String signId, String regionId, String secretId, String secretKey) {
    super(sys, channel, appId, appKey, domainName, sign, signId, regionId, secretId, secretKey);
    this.id = id;
  }
}
