package com.beiming.basic.message.dto.request;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import com.beiming.basic.message.api.ValidationMessage;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ModSmsTemplateDTO implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = -1074113017814338712L;
  
  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  private Integer id;

  /**
   * 模板id
   */
  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  private String templateId;

  /**
   * 模板名称
   */
  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  private String templateName;

  /**
   * 模板内容
   */
  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  private String templateContext;
  /**
   * key的数组或者list字符串,出现顺序和出现在短信中的顺序一致
   */
  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  private String keys;
  /**
   * 系统标识
   */
  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  private String sys;
}
