package com.beiming.basic.message.dto.request;

import java.io.Serializable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.beiming.basic.message.api.ValidationMessage;
import com.beiming.basic.message.enums.OperationType;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
@Valid
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PushTemplateRequestDTO implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 5259897239097321220L;
  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  private String templateId;
  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  private String sys;
  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  private OperationType type;
  public PushTemplateRequestDTO(@NotNull(message = "请求参数为空") String templateId,
      @NotNull(message = "请求参数为空") OperationType type) {
    super();
    this.templateId = templateId;
    this.type = type;
  }
  
}
