package com.beiming.basic.message.dto.request;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import com.alibaba.fastjson.JSONObject;
import com.beiming.basic.message.api.ValidationMessage;
import com.beiming.basic.message.common.ApiConst;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
@Data
@NoArgsConstructor
@AllArgsConstructor
public class SendSmsRequestDTO implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = 3866080584642267924L;
  @Pattern(regexp = ApiConst.REGEX_MOBILE_EXACT, message = ValidationMessage.MOBILE_PHONE_INCORRECT)
  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  private String phone;
  
  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  private String templateId;
  
  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  private JSONObject params;
}
