package com.beiming.basic.message.dto.response;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
/**
 * 短信回执部分参数
 * @see https://cloud.tencent.com/document/product/382/5807
 * @author ljf
 *
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CallbackInfo implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = -235715705887098083L;
  /**
   * 用户实际接收到短信的时间
   */
  public String userReceiveTime;
  /**
   * 实际是否收到短信接收状态，SUCCESS（成功）、FAIL（失败）
   */
  public String reportStatus;
  /**
   * 错误信息
   */
  public String errmsg;
  /**
   * 描述
   */
  public String description;
}
