package com.beiming.basic.message.dto.response;

import java.io.Serializable;
import java.util.Date;
import com.beiming.basic.message.enums.SmsChannalEnum;
import lombok.Data;
import lombok.NoArgsConstructor;
@Data
@NoArgsConstructor
public class ConfigResponseDTO implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = 6964771295232784875L;

  /**
   * 
   */
  private Integer id;

  /**
   * 系统标识,全局唯一
   */
  private String sys;

  /**
   * 短信通道,华为和腾讯
   */
  private SmsChannalEnum channel;

  /**
   * 腾讯中为应用ID,华为中为username
   */
  private String appId;

  /**
   * 腾讯中为密码密钥,华为中为password
   */
  private String appKey;

  /**
   * 目前只有华为短信用到
   */
  private String domainName;

  /**
   * 短信签名名称,腾讯指定签名发短信使用名称,华为发短信签名使用ID
   */
  private String sign;

  /**
   * 第三方签名ID
   */
  private String signId;

  /**
   * 区域,目前只有华为使用
   */
  private String regionId;
  /**
   *  腾讯云账号中的 secretId
   */
  private String secretId;
  /**
   * 腾讯云账号中的 secretKey
   */
  private String secretKey;

  /**
   * 状态 0 正常 1 删除
   */
  private String status;

  /**
   * 备注
   */
  private String remark;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 
   */
  private Date createTime;

  /**
   * 修改人
   */
  private String updateUser;

  /**
   * 
   */
  private Date updateTime;

  /**
   * 
   */
  private Integer version;

}
