package com.beiming.basic.storage.api;

import com.beiming.basic.storage.api.dto.request.FileUrlRequestDTO;
import com.beiming.basic.storage.api.dto.response.FileResponseDTO;
import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import com.beiming.basic.storage.api.dto.request.FileInfoRequestDTO;
import com.beiming.basic.storage.api.dto.response.FileInfoResponseDTO;
import com.beiming.basic.storage.api.dto.response.FilePreviewResponseDTO;
import com.beiming.basic.storage.api.dto.response.SaveFileResponseDTO;
import com.beiming.framework.domain.DubboResult;
@Valid
public interface FileStorageApi {
  /**
   * 文件上传接口
   * @param fileName 文件名称
   * @param fileByte 文件对应bytes
   * @return
   */
  public DubboResult<SaveFileResponseDTO> save(@Valid FileInfoRequestDTO requestDto);
  /**
   * <pre>
   * 文件下载接口
   * 下载所有文件
   * @param fileId
   * @return
   */
  public DubboResult<FileInfoResponseDTO> getFileInfo(@Valid @NotEmpty(message = ValidationMessage.FILEID_IS_EMPTY) String fileId);
  /**
   * <pre>
   * 下载指定目录中的文件,无需鉴权
   * @param fileId
   * @return
   */
  public DubboResult<FileInfoResponseDTO> download(@Valid @NotEmpty(message = ValidationMessage.FILEID_IS_EMPTY) String fileId);
  /**
   * 图像文件不鉴权下载
   * 只能下载可预览的文件
   * @param requestDTO
   * @return
   */
  public DubboResult<FileInfoResponseDTO> getViewImg(@Valid @NotEmpty(message = ValidationMessage.FILEID_IS_EMPTY) String fileId);
  
  public DubboResult<FileInfoResponseDTO> getNoViewImg(@Valid @NotEmpty(message = ValidationMessage.FILEID_IS_EMPTY) String fileId);
  
  /**
   * 获取文件路径，预览文件
   * @param fileId
   * @return
   */
  public DubboResult<FilePreviewResponseDTO> filePreview(@Valid @NotEmpty(message = ValidationMessage.FILEID_IS_EMPTY) String fileId);

  DubboResult<SaveFileResponseDTO> saveByDaojiaoUrl(FileUrlRequestDTO requestDTO);


  DubboResult<ArrayList<String>> getFileNameList(ArrayList<String> fileIdList);

  DubboResult<ArrayList<FileResponseDTO>> getSomeFileNameList(ArrayList<String> fileIdList);
}
