package com.beiming.basic.storage.api.dto.request;

import com.beiming.basic.storage.api.enums.TdhUploadEnums;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.FileUtils;
import com.beiming.basic.storage.api.ValidationMessage;
import com.beiming.basic.storage.api.enums.ViewEnums;

public class FileInfoRequestDTO implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = -8826795401647629326L;
  @NotEmpty(message = ValidationMessage.FILE_NAME_IS_EMPTY)
  private String fileName;
  @NotNull(message = ValidationMessage.FILE_VIEW_ENUMS_IS_NULL)
  private ViewEnums viewEnums;
  @NotNull(message = ValidationMessage.FILE_BYTES_IS_NULL)
  private byte[] fileByte;
  
  private String remark;
  private TdhUploadEnums uploadEnums;
  /**
   * 标志
   */
  private Boolean flag;
  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public byte[] getFileByte() {
    return fileByte;
  }

  public void setFileByte(byte[] fileByte) {
    this.fileByte = fileByte;
  }

  public ViewEnums getViewEnums() {
    return viewEnums;
  }

  public void setViewEnums(ViewEnums viewEnums) {
    this.viewEnums = viewEnums;
  }
  
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  public Boolean getFlag() {
    return flag;
  }
  /**
   * <pre>
   * true: 不压缩,直接放到common目录下
   * false或者null则走原流程
   * @param flag
   */
  public void setFlag(Boolean flag) {
    this.flag = flag;
  }

  /**
   * 
   * @param fileName
   * @param file
   * @param viewEnums ViewEnums.VIEW时可预览
   * @throws IOException
   */
  public FileInfoRequestDTO(String fileName, File file, ViewEnums viewEnums) throws IOException {
    super();
    this.fileName = fileName;
    this.fileByte = FileUtils.readFileToByteArray(file);
    this.viewEnums = viewEnums;
  }
  /**
   * 
   * @param fileName
   * @param fileByte
   * @param viewEnums  ViewEnums.VIEW时可预览
   */
  public FileInfoRequestDTO(String fileName, byte[] fileByte, ViewEnums viewEnums) {
    super();
    this.fileName = fileName;
    this.fileByte = fileByte;
    this.viewEnums = viewEnums;
  }
  /**
   * 默认不可预览
   * @param fileName
   * @param file
   * @throws IOException
   */
  public FileInfoRequestDTO() {
    super();
  }

  public FileInfoRequestDTO(String fileName, File file) throws IOException {
    super();
    this.fileName = fileName;
    this.fileByte = FileUtils.readFileToByteArray(file);
    this.viewEnums = ViewEnums.CANNOT_VIEW;
  }
  /**
   * 默认不可预览
   * @param fileName
   * @param fileByte
   */
  public FileInfoRequestDTO(String fileName, byte[] fileByte) {
    super();
    this.fileName = fileName;
    this.fileByte = fileByte;
    this.viewEnums = ViewEnums.CANNOT_VIEW;
  }
  /**
   * 默认不可预览
   * @param fileName
   * @param fileByte
   * @param remark (可选)
   */
  public FileInfoRequestDTO(String fileName, byte[] fileByte, String remark) {
    super();
    this.fileName = fileName;
    this.fileByte = fileByte;
    this.remark = remark;
    this.viewEnums = ViewEnums.CANNOT_VIEW;
  }

  public void setUploadEnums(TdhUploadEnums uploadEnums) {
    this.uploadEnums = uploadEnums;
  }

}
