package com.beiming.basic.storage.api.dto.request;

import com.beiming.basic.storage.api.ValidationMessage;
import java.io.Serializable;
import javax.validation.constraints.NotEmpty;
import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;

/**
 * @Auther: XZY
 * @Date: 2019/3/19/019 13:52
 * @Description:
 */
@AllArgsConstructor
@NoArgsConstructor
public class FileUrlRequestDTO implements Serializable {
  @NotEmpty(message = ValidationMessage.FILE_NAME_IS_EMPTY)
  private String fileName;
  @NotEmpty(message = ValidationMessage.FILE_URL_IS_EMPTY)
  private String url;
  //用户id
  private String userId;
  //用户名称
  private String userName;
  //解密密钥
  private String securityKey;
  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public String getUserId() {
    return userId;
  }

  public void setUserId(String userId) {
    this.userId = userId;
  }

  public String getSecurityKey() {
    return securityKey;
  }

  public void setSecurityKey(String securityKey) {
    this.securityKey = securityKey;
  }

  public String getUserName() {
    return userName;
  }

  public void setUserName(String userName) {
    this.userName = userName;
  }
}
