package com.beiming.basic.storage.api.dto.response;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;

public class FileInfoResponseDTO implements Serializable {
  /**
   * 
   */
  private static final long serialVersionUID = 3691159600940771116L;
  private String fileName;
  private byte[] fileByte;
  /**
   * 文件路径
   */
  private String filePath;

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public byte[] getFileByte() {
    return fileByte;
  }

  public void setFileByte(byte[] fileByte) {
    this.fileByte = fileByte;
  }

  public String getFilePath() {
    return filePath;
  }

  public void setFilePath(String filePath) {
    this.filePath = filePath;
  }
  
  /**
   * 获取文件流,使用完毕请关闭该流
   * @return
   * @throws IOException
   */
  public InputStream getInputStream() throws IOException {
    return new ByteArrayInputStream(fileByte);
  }
  
  public FileInfoResponseDTO() {
    super();
  }

  public FileInfoResponseDTO(String fileName, File file) throws IOException {
    super();
    this.fileName = fileName;    
    this.fileByte = FileUtils.readFileToByteArray(file);
  }

  public FileInfoResponseDTO(String fileName, File file, String filePath) throws IOException {
    super();
    this.fileName = fileName;
    this.fileByte = FileUtils.readFileToByteArray(file);
    this.filePath = filePath;
  }
}
