/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.nacos.server.springcloud;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class NacosServerEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(NacosServerEnvironmentPostProcessor.class);
    private static final String PROPERTY_SOURCE_NAME = "defaultProperties";
    public static final String SPRING_CLOUD_NACOS_CONFIG_SERVER_ADDR = "SPRING_CLOUD_NACOS_CONFIG_SERVER_ADDR";
    public static final String SPRING_CLOUD_NACOS_USERNAME = "SPRING_CLOUD_NACOS_USERNAME";
    public static final String SPRING_CLOUD_NACOS_PASSWORD = "SPRING_CLOUD_NACOS_PASSWORD";
    public static final String USERNAME = "spring.cloud.nacos.username";
    public static final String PASSWORD = "spring.cloud.nacos.password";
    public static final String SERVER_ADDR = "spring.cloud.nacos.config.server-addr";
    public static final String FILE_EXTENSIION = "spring.cloud.nacos.config.file-extension";
    public static final String NAMESPACE = "spring.cloud.nacos.config.namespace";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        log.info("welcome use nacos , begin init config, get activeProfiles... ");
        PropertySource system = environment.getPropertySources().get("systemEnvironment");
        Object serverAddr = system.getProperty(SPRING_CLOUD_NACOS_CONFIG_SERVER_ADDR);
        Object userName = system.getProperty(SPRING_CLOUD_NACOS_USERNAME);
        Object password = system.getProperty(SPRING_CLOUD_NACOS_PASSWORD);
        if (serverAddr == null || userName == null || password == null) {
            serverAddr = environment.getProperty(SERVER_ADDR);
            userName = environment.getProperty(USERNAME);
            password = environment.getProperty(PASSWORD);
            if (serverAddr == null || userName == null || password == null) {
                log.warn("nacos config is missing, use project config");
            }
        }
        String[] activeProfiles = environment.getActiveProfiles();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FILE_EXTENSIION, "yml");
        map.put(USERNAME, userName);
        map.put(PASSWORD, password);
        map.put(SERVER_ADDR, serverAddr);
        MapPropertySource target = new MapPropertySource(PROPERTY_SOURCE_NAME, map);
        MutablePropertySources propertySources = environment.getPropertySources();
        if (propertySources.contains(PROPERTY_SOURCE_NAME)) {
            PropertySource source = propertySources.get(PROPERTY_SOURCE_NAME);
            try {
                target = (MapPropertySource)source;
                for (String key : map.keySet()) {
                    if (target.containsProperty(key)) continue;
                    ((Map)target.getSource()).put(key, map.get(key));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!propertySources.contains(PROPERTY_SOURCE_NAME)) {
            environment.getPropertySources().addLast((PropertySource)target);
        }
    }
}

