package com.beiming.nonlitigation.business.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.nonlitigation.business.requestdto.ArbitrationStatisticsRequestDTO;
import com.beiming.nonlitigation.business.responsedto.ArbitrationResponseDTO;
import com.beiming.nonlitigation.business.responsedto.ArbitrationStatisticsReportDTO;
import com.beiming.nonlitigation.business.responsedto.ArbitrationStatisticsResponseDTO;

import java.util.ArrayList;

/**
 * 仲裁委API接口
 */
public interface ArbitrationStatisticsServiceApi {

  /**
   * 新增或者编辑仲裁委统计
   *
   * @param arbitrationStatisticsRequestDTO dto
   * @return res
   */
  DubboResult saveArbitrationStatistics(ArbitrationStatisticsRequestDTO arbitrationStatisticsRequestDTO);

  /**
   * 查看仲裁委统计值
   */
  DubboResult<ArrayList<ArbitrationStatisticsResponseDTO>> getArbitrationStatistics(String registerTime, String cityCode, String arbitrationName, String provCode);

  /**
   * 仲裁委列表
   */
  DubboResult<ArrayList<ArbitrationResponseDTO>> listArbitration(Long userId, Boolean dataRange, String provCode);

  /**
   * 获取仲裁委统计记录
   * @param cityCode
   * @param registerTime
   * @return
   */
  DubboResult<ArbitrationStatisticsResponseDTO> getArbitrantionByCodeTime(String cityCode, String registerTime);

  /**
   * 统计上报
   */
  DubboResult<ArrayList<ArbitrationStatisticsReportDTO>> reportStatistical(String date);
}
