package com.beiming.nonlitigation.business.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.nonlitigation.business.common.enums.ProgressTypeEnum;
import com.beiming.nonlitigation.business.domain.LawProgress;
import java.util.ArrayList;
import java.util.Map;

/**
 * 案件进度相关接口
 */
public interface CaseProgressServiceApi {

  /**
   * @param modelCode ProgressModelEnum枚举.name()
   * @param replace 需要替换的值 注意包含#号
   * @param lawProgress 实体
   * @return
   * @desc 进度插入(调解进度)
   * 操作数据库 调用注意添加事务 @Transactional
   */
  DubboResult insertProgress(String modelCode, Map<String, String> replace,
      LawProgress lawProgress);

  /**
   * 插入流转进度
   * 操作数据库 调用注意添加事务 @Transactional
   */
  DubboResult insertCirculation(LawProgress lawProgress);

  /**
   * 根据类型获取进度获取进度
   */
  DubboResult<ArrayList<LawProgress>> getProgressByType(Long caseId, ProgressTypeEnum type);
}
