package com.beiming.nonlitigation.business.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.nonlitigation.business.domain.LittleMediator;
import com.beiming.nonlitigation.business.requestdto.MediatorQueryDTO;
import com.beiming.nonlitigation.business.responsedto.MediatorResponseDTO;
import com.github.pagehelper.PageInfo;
import java.util.List;

/**
 * 区域服务API接口
 */
public interface LittleMediatorServiceApi {

  /**
   * 批量插入小助手调解员信息
   */
  DubboResult bathAdd(List<LittleMediator> littleMediatorList, String areaCode);

  /**
   * 删除小助手调解员信息
   */
  DubboResult delete(LittleMediator littleMediator);

  /**
   * 随机查询一条小助手调解员信息
   */
  DubboResult<LittleMediator> selectOne(LittleMediator littleMediator);

  /**
   * 分页查询小助手调解员
   */
  PageInfo<MediatorResponseDTO> pageLittleMediatorList(MediatorQueryDTO requestDTO);


  DubboResult<LittleMediator> getAreaCode(String mechanismId, String mediatorId);
}