package com.beiming.nonlitigation.business.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.nonlitigation.business.common.enums.CaseResultEnum;
import com.beiming.nonlitigation.business.domain.LogUsage;
import com.beiming.nonlitigation.business.requestdto.LogUsageDto;
import com.beiming.nonlitigation.business.responsedto.UserUsageLogDto;
import com.github.pagehelper.PageInfo;

/**
 * @author songfeng
 * @date 2021/07/08
 */
public interface LogUsageServiceApi {

  /**
   * 增加模块调用日志信息
   *
   * @param dto
   * @param userId
   * @param username
   */
  void addLogUsage(LogUsageDto dto, Integer userId, String username);

  /**
   * 案件
   *
   * @param userUsageLogDto
   */
  void caseAsync(UserUsageLogDto userUsageLogDto);

  /**
   * 机构人员
   *
   * @param userUsageLogDto
   */
  void mechanismAsync(UserUsageLogDto userUsageLogDto);

  /**
   * 系统管理
   *
   * @param userUsageLogDto
   */
  void systemAsync(UserUsageLogDto userUsageLogDto);


  void caseHandle(CaseResultEnum caseResultEnum, UserUsageLogDto userUsageLogDto);

  DubboResult<PageInfo<LogUsage>> getLogUsageList(Integer pageNum, Integer pageSize);

  void updateLogUsage(LogUsage logUsage);
}
