package com.beiming.nonlitigation.business.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.nonlitigation.business.domain.Role;
import com.beiming.nonlitigation.business.otherdto.UserRoleRelationDTO;
import com.beiming.nonlitigation.business.requestdto.RoleAddRequestDTO;
import com.beiming.nonlitigation.business.requestdto.RoleQueryRequestDTO;
import com.beiming.nonlitigation.business.requestdto.RoleUpdateRequestDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 角色相关接口
 */
public interface RoleServiceApi {

  /**
   * 获取用户角色
   */
  DubboResult<ArrayList<Role>> getUserRole(Long userId);

  /**
   * 角色条件查询接口
   *
   * @return DubboResult<PageInfo < RoleQueryResponseDTO>>
   */
  DubboResult roleQuery(RoleQueryRequestDTO roleQueryDTO);

  /**
   * 新增角色
   *
   * @return DubboResultBuilder.success()
   */
  DubboResult roleAdd(RoleAddRequestDTO roleAddRequestDTO);

  /**
   * 修改角色
   *
   * @return DubboResultBuilder.success()
   */
  DubboResult roleUpdate(RoleUpdateRequestDTO roleUpdateRequestDTO);

  /**
   * 查询角色类型枚举
   */
  Map getRoleType();

  List<Role> getRoleList(String userId);

  DubboResult roleDetail(Long roleId);


  /**
   * 查询角色详情(包含对应的区域信息)
   *
   * @param userId 用户id 必传
   */
  List<UserRoleRelationDTO> getUserRoleRelationDTO(Long userId);
}
