package com.beiming.nonlitigation.business.api;

import com.beiming.framework.domain.APIResult;
import com.beiming.nonlitigation.business.requestdto.RegisterInfoDto;
import com.beiming.nonlitigation.business.requestdto.UserSimplifyLoginRequestDTO;

/**
 * @author songfeng
 * @date 2021/07/19
 */
public interface UserWechatServiceTwoApi {

  /**
   * 简化版登录注册
   *
   * @param dto
   * @return
   */
  APIResult simplifyRegisteredLogin(UserSimplifyLoginRequestDTO dto);

  /**
   * 判断是否注册过
   *
   * @param dto
   * @return
   */
  APIResult checkRegisteredStatus(UserSimplifyLoginRequestDTO dto);

  /**
   * 简化版登录
   * @param dto
   * @return
   */
  APIResult simplifyLogin(UserSimplifyLoginRequestDTO dto);

  /**
   * 简化版注册
   *
   * @param dto
   * @return
   */
  APIResult simplifyRegistered(UserSimplifyLoginRequestDTO dto);


  /**
   * 实名认证
   *
   * @param registerInfo
   * @param userId
   * @return
   */
  APIResult editFacialVerify(RegisterInfoDto registerInfo, Long userId);

  /**
   * 增加校验接口
   * @param registerInfo
   * @return
   */
  APIResult checkFaceVerification(RegisterInfoDto registerInfo);

  /**
   * 查询信息
   * @param id 用户的id
   * @return
   */
  APIResult selectUserData(Long id);

  /**
   * 根据用户id获取身份证
   * @param userId
   * @return
   */
  APIResult getIdCard(String userId);
}
