package com.beiming.nonlitigation.business.api;

import com.alibaba.fastjson.JSONObject;
import com.beiming.framework.domain.DubboResult;
import com.beiming.nonlitigation.business.common.enums.DisputeTypeEnum;
import com.beiming.nonlitigation.business.requestdto.AddCaseRequestDTO;
import com.beiming.nonlitigation.business.requestdto.AddInstrumentRequestDTO;
import com.beiming.nonlitigation.business.requestdto.CaseHandleRequestDTO;
import com.beiming.nonlitigation.business.requestdto.UpdateAgentInfoDTO;
import com.beiming.nonlitigation.business.requestdto.UpdateCaseDetailsDTO;
import com.beiming.nonlitigation.business.requestdto.UpdatePersonInfoDTO;

/**
 * 案件操作（办理等）相关接口
 */
public interface CaseHandleServiceApi {

  public DubboResult restOrg(Long caseId);
  /**
   * 案件办理（受理、不受理、办理成功、办理失败、当事人撤回）
   */
  DubboResult caseHandle(CaseHandleRequestDTO caseHandle);

  /**
   * 获取服务机构登记能提交的分派岗信息
   */
  DubboResult getPostMechanism(Long orgId);

  /**
   * 撤销登记
   */
  DubboResult returnRegist(Long caseId, Long userId, String remark);


  DubboResult deleteInstrument(Long caseId, Long id);

  DubboResult addInstrument(AddInstrumentRequestDTO addInstrumentRequestDTO);

  DubboResult updateDisputeType(Long caseId, DisputeTypeEnum disputeTypeCode);

  DubboResult updateCaseDetails(UpdateCaseDetailsDTO updateCaseDetailsDTO);

  DubboResult updatePersonInfo(UpdatePersonInfoDTO updatePersonInfoDTO);

  DubboResult updateAgentInfo(UpdateAgentInfoDTO updateAgentInfoDTO);

  /**
   * 回填odr业务id
   */
  DubboResult saveOdrId(JSONObject odrCaseInfo, AddCaseRequestDTO caseDetail);
}
