package com.beiming.nonlitigation.business.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.nonlitigation.business.requestdto.CaseInfoRequestDTO;
import com.beiming.nonlitigation.business.requestdto.CaseResultRequestDTO;
import com.beiming.nonlitigation.business.requestdto.CaseTransferDTO;
import com.beiming.nonlitigation.business.requestdto.CaseTransferUpdateDTO;
import com.beiming.nonlitigation.business.requestdto.OdrCaseRequestDTO;

/**
 * 案件信息同步相关接口
 */
public interface CaseSyncServiceApi {

  /**
   * ODR案件信息同步到非诉
   */
  DubboResult caseInfoSyncToFs(CaseInfoRequestDTO caseInfoRequestDTO);

  /**
   * ODR案件状态同步到非诉
   */
  DubboResult caseStateSyncToFs(CaseResultRequestDTO caseResult);

  DubboResult<OdrCaseRequestDTO> transferToOdrCase(CaseTransferDTO caseTransferDTO, String createUserId);
  DubboResult<OdrCaseRequestDTO> updateCaseFlow(CaseTransferUpdateDTO caseTransferDTO);
}
