package com.beiming.nonlitigation.business.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.nonlitigation.business.responsedto.HomeCaseOriginResponseDTO;
import com.beiming.nonlitigation.business.responsedto.HomeStatisticsResponseDTO;
import com.beiming.nonlitigation.business.responsedto.HomeCaseTypeResponseDTO;

import java.util.ArrayList;

/**
 * 首页统计相关接口
 */
public interface HomeStatisticsServiceApi {

    /**
     * 本月分派至所辖机构案件统计
     */
  DubboResult<ArrayList<HomeStatisticsResponseDTO>> monthLawCaseStatistics(
          Long userId, Long menuId, String startTime, String endTime);

    /**
     * 本月省市区分派案件统计
     */
  DubboResult<ArrayList<HomeStatisticsResponseDTO>> monthDistrictStatistics(
          Long userId, Long menuId, String startTime, String endTime);

    /***
     * 本月案件处理结果统计
     */
  DubboResult<ArrayList<HomeStatisticsResponseDTO>> monthMediateResultStatistics(
          Long userId, Long menuId, String circulationStatus, String startTime, String endTime);

  /***
   * 本机构进展状态统计
   */
  DubboResult<ArrayList<HomeStatisticsResponseDTO>> progressStatusStatistics(
          Long userId, Long menuId, String progressStatus);

  /**
   * 本月案件类型排行统计
   */
  DubboResult<ArrayList<HomeCaseTypeResponseDTO>> monthCaseTypeStatistics(
          Long userId, Long menuId, String caseType, String startTime, String endTime, String lastMonthStartTime, String lastMonthEndTime);

  /**
   * 每月案件来源统计
   * @param userId
   * @param menuId
   * @param caseOrigin
   * @param year
   * @return
   */
  DubboResult<ArrayList<HomeCaseOriginResponseDTO>> caseOriginStatistics(
          Long userId, Long menuId, String caseOrigin, String year);

  /***
   * 所辖机构及所属人员统计
   */
  DubboResult<ArrayList<HomeStatisticsResponseDTO>> mechanismAndPersonnelStatistics(
          Long userId, Long menuId);
}
