package com.beiming.nonlitigation.business.api;

import com.beiming.framework.domain.APIResult;
import com.beiming.nonlitigation.business.domain.User;
import com.beiming.nonlitigation.business.requestdto.AcceptVerificationCodeDto;
import com.beiming.nonlitigation.business.requestdto.EditPhoneDto;
import com.beiming.nonlitigation.business.requestdto.EditUserPasswordDto;
import com.beiming.nonlitigation.business.requestdto.SendSmsDto;
import com.beiming.nonlitigation.business.requestdto.UserIpAdressDTO;
import com.beiming.nonlitigation.business.requestdto.UserLoginRequestDTO;
import com.beiming.nonlitigation.business.requestdto.VerificationUserDto;
import com.beiming.nonlitigation.business.requestdto.WeChatUserLoginPasswordDto;
import com.beiming.nonlitigation.business.responsedto.WeChatUserInfoResponseDTO;
import java.util.List;

/**
 * @author songfeng
 * @date 2021/05/10
 */
public interface UserWechatServiceApi {

  /**
   * 用户是否注册
   *
   * @param phone
   * @return
   */
  APIResult judgmentUserDetail(String phone);

  /**
   * 发送短信验证码
   *
   * @param dto
   * @return
   */
  APIResult sendSms(SendSmsDto dto, String password);

  /**
   * 接受短信验证码
   *
   * @param dto
   * @return
   */
  APIResult acceptSms(AcceptVerificationCodeDto dto);


  /**
   * 修改密码
   *
   * @param dto
   * @return
   */
  APIResult editPassword(EditUserPasswordDto dto);

  Integer insert(User user);

  User findUserEntityByOpenId(String phone);


  /**
   * 根据openId查询用户信息
   *
   * @param openId
   * @return
   */
  User queryUser(String openId);


  /**
   * 验证用户信息
   *
   * @return
   */
  APIResult verificationUser(VerificationUserDto verificationUserDto);

  /**
   * 微信用户账号密码登录
   *
   * @param weChatUserLoginPasswordDto
   * @return
   */
  WeChatUserInfoResponseDTO weChatUserLoginPassword(
      WeChatUserLoginPasswordDto weChatUserLoginPasswordDto);

  User verificationLoginRegister(UserLoginRequestDTO dto);

  /**
   * 修改绑定的身份证号
   *
   * @param dto
   * @return
   */
  APIResult editPhone(EditPhoneDto dto);

  void updateUserAreaCode(UserIpAdressDTO userIpAdressDTO);

  void updateUserAreaCodeByLatitudeAndLongitude(UserIpAdressDTO userIpAdressDTO);

  List<UserIpAdressDTO> getUserAreaLost(String limit);

  void updateUserArea(List<UserIpAdressDTO> updateList);
}
