package com.beiming.nonlitigation.business.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.nonlitigation.business.domain.Areas;
import com.beiming.nonlitigation.business.requestdto.AreaRequestDTO;
import com.beiming.nonlitigation.business.responsedto.AreaResponseDTO;
import com.beiming.nonlitigation.business.responsedto.AreaTreeDTO;
import com.beiming.nonlitigation.business.responsedto.AreaTreeResponseDTO;
import java.util.ArrayList;
import java.util.List;

/**
 * 区域服务API接口
 */
public interface AreaServiceApi {

  /**
   * 查询区域信息
   */
  DubboResult<ArrayList<AreaResponseDTO>> list(AreaRequestDTO areaRequestDTO);

  /**
   * 根据区域code查询区域详情
   */
  DubboResult<Areas> selectByCode(String regionCode);

  /**
   * 用户管辖行政区划
   */
  DubboResult<ArrayList<AreaTreeResponseDTO>> getUserAreas(List<String> regionCodes, Integer level);


  /**
   * 获取区划本身及其子级
   */
  DubboResult<ArrayList<Areas>> selectAllByCode(String regionCode, Integer level);

  DubboResult<ArrayList<AreaTreeDTO>> areaTree();
}