package com.beiming.nonlitigation.business.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.nonlitigation.business.requestdto.AddCaseRequestDTO;
import com.beiming.nonlitigation.business.requestdto.AssociatedCaseDTO;
import com.beiming.nonlitigation.business.requestdto.CaseRequestDTO;
import com.beiming.nonlitigation.business.responsedto.CaseInfoResponseDTO;
import com.beiming.nonlitigation.business.responsedto.CaseTypeStatisticsResponseDTO;
import com.github.pagehelper.PageInfo;

/**
 * @author houqingxin
 * @Description: 关联案件
 * @date 2019/11/5 10:31
 */
public interface AssociatedCaseServiceApi {

  /**
   * 获取案件列表
   */
  DubboResult<PageInfo<CaseInfoResponseDTO>> getCaseList(CaseRequestDTO caseReqDTO);

  /**
   * 获取关联案件列表
   * @param caseReqDTO
   * @return
   */
  DubboResult<PageInfo<CaseInfoResponseDTO>> getAssociatedCaseList(AssociatedCaseDTO caseReqDTO);


  DubboResult<PageInfo<CaseTypeStatisticsResponseDTO>> getReRegisterCaseType(Long caseId);
  DubboResult<PageInfo<CaseTypeStatisticsResponseDTO>> getCaseType(Long caseId);


  /**
   * 编辑案件
   */
  DubboResult webEditCase(AddCaseRequestDTO addCaseRequestDto);
}
