package com.beiming.nonlitigation.business.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.nonlitigation.business.common.enums.CaseResultEnum;
import com.beiming.nonlitigation.business.domain.LawCase;
import com.beiming.nonlitigation.business.requestdto.CaseRequestDTO;
import com.beiming.nonlitigation.business.responsedto.CaseInfoResponseDTO;
import com.github.pagehelper.PageInfo;

/**
 * 案件相关接口
 */
public interface CaseServiceApi {
  /**
   * 更改案件状态
   */
  DubboResult changeCaseStatus(Long caseId, CaseResultEnum caseResultEnum);

  /**
   * 获取案件列表
   */
  DubboResult<PageInfo<CaseInfoResponseDTO>> getCaseList(CaseRequestDTO caseReqDTO);

  /**
   * web端查询案件详情
   */
  DubboResult caseDetailInfo(Long id, String currentUserId);

  /**
   * 获取案件详情(更详细的)
   */
  DubboResult getCaseDetail(Long id);

  /**
   * 获取枚举类的列表
   */
  DubboResult getEnumTypeList(String type);

  /**
   * 根据主键ID查询案件信息
   */
  DubboResult<LawCase> selectByPrimaryKey(Long id);

  /**
   * 更新案件信息
   */
  DubboResult updateLawCase(LawCase lawCase);

  DubboResult getToken();
}
