package com.beiming.nonlitigation.business.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.nonlitigation.business.responsedto.CaseStatusStatisticsResponseDTO;
import com.beiming.nonlitigation.business.responsedto.CaseTypeStatisticsResponseDTO;
import com.beiming.nonlitigation.business.responsedto.CirculationStatusStatisticsResponseDTO;
import java.util.ArrayList;

/**
 * 案件统计相关接口
 */
public interface CaseStatusStatisticsServiceApi {

  /**
   * 案件类型统计
   */
  DubboResult<ArrayList<CaseTypeStatisticsResponseDTO>> caseTypeStatistics(Long userId, Long menuId,
      Boolean dataRange, String circulationStatus, String mediateResult);

  /**
   * 案件主状态统计
   */
  DubboResult<ArrayList<CaseStatusStatisticsResponseDTO>> caseStatusStatistics(Long userId,
      Long menuId, String caseStatus);

  /**
   * 案件流转状态统计
   */
  DubboResult<ArrayList<CirculationStatusStatisticsResponseDTO>> circulationStatusStatistics(
      Long userId, Long menuId, String circulationStatus, String mediateResult);
}
