package com.beiming.nonlitigation.business.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.nonlitigation.business.common.enums.OdrFileSignEnum;
import com.beiming.nonlitigation.business.domain.FileInfo;
import com.beiming.nonlitigation.business.responsedto.FileInfoResponseDTO;
import com.github.pagehelper.PageInfo;
import java.util.List;

/**
 * 文件相关接口
 */
public interface FileServiceApi {

  /**
   * 根据文件id获取文件信息
   */
  DubboResult<FileInfo> getFileById(Long fileId);

  /**
   * 获取案件相关文件
   *
   * @param caseId 必传
   * @param fileTypes 文件类型，可传
   * @param bizId 子类，具体某个业务的外键
   */
  DubboResult<PageInfo<FileInfo>> getFileInfoList(Long caseId, List<String> fileTypes,
      Long bizId, Integer pageSize, Integer currPage);

  /**
   * 保存上传文件信息
   */
  DubboResult addFileInfo(Long caseId, List<String> urls , OdrFileSignEnum fileTypeEnum);

  /**
   * 根据案件ID获取所有附件
   * @param caseId 案件ID
   * @return 附件列表
   */
  DubboResult<FileInfoResponseDTO> getCaseFileByCaseId(Long caseId);

  DubboResult updateOdrId(String odrId, Long id);
}
