package com.beiming.nonlitigation.business.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.nonlitigation.business.common.enums.RoleTypeEnum;
import com.beiming.nonlitigation.business.domain.Mechanism;
import com.beiming.nonlitigation.business.requestdto.CaseTransferDTO;
import com.beiming.nonlitigation.business.requestdto.DepartmentRequestDTO;
import com.beiming.nonlitigation.business.requestdto.GetOrgIdForTransferDTO;
import com.beiming.nonlitigation.business.requestdto.MechanismPageRequestDTO;
import com.beiming.nonlitigation.business.requestdto.MechanismRequestDTO;
import com.beiming.nonlitigation.business.responsedto.AreaTreeResponseDTO;
import com.beiming.nonlitigation.business.responsedto.DepartmentPageResponseDTO;
import com.beiming.nonlitigation.business.responsedto.DepartmentResponseDTO;
import com.beiming.nonlitigation.business.responsedto.MechanismResponse;
import com.beiming.nonlitigation.business.responsedto.MechanismResponseDTO;
import com.beiming.nonlitigation.business.responsedto.MechanismTreeResponseDTO;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;

/**
 * 机构api
 */
public interface MechanismServiceApi {

  /**
   * 根据行政区划代码获取机构信息
   * @param regionCode 行政区划代码
   * @return 机构信息
   */
  DubboResult<Mechanism> getMechanismByRegionCode(String regionCode);

  /**
   * 获取该机构 所有上级机构和下级机构的信息
   */
  DubboResult<MechanismResponse> getRelationMechanism(GetOrgIdForTransferDTO getOrgIdForTransferDTO);

  /**
   * 案件转办
   */
  DubboResult transfer(CaseTransferDTO caseTransferDTO, String createUserId);

  /**
   * 添加或修改机构
   */
  DubboResult addOrUpdateMechanism(MechanismRequestDTO mechanismRequestDTO);

  /**
   * 查询区域管辖范围内的同类型下级机构 服务机构查询服务机构/司法机构查询司法机构
   *
   * @param ids 机构ids
   * @param roleTypeEnum 支持 服务机构和司法类型机构
   */
  List<Long> getOrgDownIds(List<Long> ids, RoleTypeEnum roleTypeEnum);

  /**
   * 添加或修改职能部门
   */
  DubboResult addOrUpdateDepartment(DepartmentRequestDTO departmentRequestDTO);

  /**
   * 获取组织机构详情
   */
  DubboResult<MechanismResponseDTO> selectMechanismDetailById(Long id);

  /**
   * 获取职能部门详情
   */
  DubboResult<DepartmentResponseDTO> selectDepartmentDetailById(Long id);

  /**
   * 根据机构id,获取管辖范围内的不同类型的下级机构; 例如:组织机构查询管辖范围内的服务机构    (传,RoleTypeEnum.JUDICIAL_ADMINISTRATION)
   * 例如:服务机构查询管辖范围内的司法机构    (传,RoleTypeEnum.SERVICE_INSTITUTIONS)
   *
   * @param ids 机构ids
   * @param roleTypeEnum 机构ids的类型
   */
  List<Long> getOrgAreaIds(List<Long> ids, RoleTypeEnum roleTypeEnum);

  /**
   * 获取当前用户组织机构部门（树形）
   */
  DubboResult<ArrayList<MechanismTreeResponseDTO>> getUserMechanism(List<String> regionCodes);

  /**
   * 获取职能部门列表（树形）
   */
  DubboResult<ArrayList<MechanismTreeResponseDTO>> getDepartmentTree(Long id);

  /**
   * 获取职能部门列表（分页）
   */
  DubboResult<PageInfo<DepartmentPageResponseDTO>> departmentPageList(
      MechanismPageRequestDTO mechanismPageRequestDTO);

  /**
   * 获取用户管辖行政区划
   */
  DubboResult<ArrayList<AreaTreeResponseDTO>> getUserAreas(List<String> regionCodes);

  /**
   * 获取用户的组织机构（省、市级）
   */
  DubboResult<ArrayList<MechanismResponseDTO>> getUserMechanisms(List<String> regionCodes,
      String regionCode, Long mechanismId);

  /**
   * 获取职能部门列表（下拉框树形）
   */
  DubboResult<ArrayList<MechanismTreeResponseDTO>> getDepartmentSelectTree(Long mechanismId);

  /**
   * 删除部门
   */
  DubboResult deleteDepartment(Long id);

  /**
   *
   * @param mechanismId
   * @return
   */
  DubboResult<MechanismResponseDTO> getMechanismByPkId(Long mechanismId);

}
