package com.beiming.nonlitigation.business.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.nonlitigation.business.domain.Organization;
import com.beiming.nonlitigation.business.requestdto.MediatorQueryDTO;
import com.beiming.nonlitigation.business.requestdto.QueryOrgRequestDTO;
import com.beiming.nonlitigation.business.requestdto.QueryPerRequestDTO;
import com.beiming.nonlitigation.business.requestdto.SaveOrgRequestDTO;
import com.beiming.nonlitigation.business.requestdto.UpdatePerRequestDTO;
import com.beiming.nonlitigation.business.responsedto.MediatorResponseDTO;
import com.github.pagehelper.PageInfo;

/**
 * 机构人员管理相关接口
 */
public interface OrgServiceApi {

  /**
   * 新增或者编辑机构
   *
   * @param saveOrgRequestDTO dto
   * @return res
   */
  DubboResult saveOrg(SaveOrgRequestDTO saveOrgRequestDTO);

  /**
   * 查看机构
   *
   * @param id id
   * @return res
   */
  DubboResult getOrg(Integer id);

  /**
   * 删除机构
   *
   * @param id id
   * @return res
   */
  DubboResult delOrg(Integer id);

  /**
   * 机构列表
   */
  DubboResult listOrg(QueryOrgRequestDTO queryOrgRequestDTO);

  /**
   * 人员管理列表
   */
  DubboResult listPer(QueryPerRequestDTO queryPerRequestDTO);

  /**
   * 编辑人员信息
   */
  DubboResult updatePer(UpdatePerRequestDTO updatePerRequestDTO);

  /**
   * 人员信息
   */
  DubboResult getPer(Integer id);

  DubboResult checkName(String userName);

  DubboResult getServiceRole();

  /**
   * 分页查询非诉平台服务机构
   */
  PageInfo<MediatorResponseDTO> pageMediatorList(MediatorQueryDTO requestDTO);

  DubboResult listMyOrg(String userId);

  DubboResult listAddOrg(String userId);

  /**
   * 获取机构
   */
  DubboResult<Organization> getOrgById(Object orgId);
}
