package com.beiming.nonlitigation.business.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.nonlitigation.business.requestdto.CourtTransferRequestDTO;
import com.beiming.nonlitigation.business.requestdto.StatisticRequestDTO;
import com.beiming.nonlitigation.business.responsedto.*;

import java.text.ParseException;

/**
 * 统计
 * @author 刘毅
 */
public interface StatisticsServiceApi {

  /**
   * 法院转办统计
   * @param data 入参 CourtTransferRequestDTO
   * @return 统计信息
   */
  DubboResult<CourtTransferDTO> courtTransfer(CourtTransferRequestDTO data);

  /**
   * 案件来源统计
   * @param param 入参 StatisticRequestDTO
   * @return 统计信息
   */
  DubboResult<StatisticsCaseOriginResponseDTO> caseOrigin(StatisticRequestDTO param);

  /**
   * 案件分布
   * @param param 入参 StatisticRequestDTO
   * @return 统计信息
   */
  DubboResult<StatisticsCaseDistributeResponseDTO> caseDistribute(StatisticRequestDTO param) throws ParseException;

  /**
   * 机构信息统计
   * @param param StatisticRequestDTO
   * @return 统计信息
   */
  DubboResult<StatisticsOrganizationResponseDTO> getOrganization(StatisticRequestDTO param);

  /**
   * 非诉平台案件受理统计
   * @param param StatisticRequestDTO
   * @return 统计信息
   */
  DubboResult<StatisticsCaseTotalResponseDTO> getCaseTotal(StatisticRequestDTO param);
}
