package com.beiming.nonlitigation.business.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.nonlitigation.business.common.enums.JudgeEnum;
import com.beiming.nonlitigation.business.common.enums.UserTypeEnum;
import com.beiming.nonlitigation.business.domain.User;
import com.beiming.nonlitigation.business.otherdto.UserRoleRelationDTO;
import com.beiming.nonlitigation.business.requestdto.RoleOrgRequestDTO;
import com.beiming.nonlitigation.business.requestdto.UserAddRequestDTO;
import com.beiming.nonlitigation.business.requestdto.UserEnabledRequestDTO;
import com.beiming.nonlitigation.business.requestdto.UserPasswordRequestDTO;
import com.beiming.nonlitigation.business.requestdto.UserSearchRequestDTO;
import com.beiming.nonlitigation.business.requestdto.UserUpdateRequestDTO;
import com.beiming.nonlitigation.business.responsedto.*;
import com.github.pagehelper.PageInfo;
import com.qizhong.panda.utils.AppException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 用户相关接口
 */
public interface UserServiceApi {

  /**
   * 用户登录 通过loginName
   */
  DubboResult<LoginInfoResponseDTO> userLogin(UserTypeEnum userType, String loginName,
      String password);

  //DubboResult<LoginInfoResponseDTO> userLoginByUkey(String ukey);

  /**
   * 重置密码
   */
  DubboResult resetPassword(Long userId, String password);

  DubboResult resetAllPassword();

  /**
   * 根据用户id获取用户信息
   */
  DubboResult<User> getUserById(Long userId);

  DubboResult<UsersVO> queryUserToUpdateArea();

  /**
   * 根据用户手机获取用户信息
   */
  DubboResult<User> getUserByPhone(UserTypeEnum userType, String phone);

  /**
   * 根据用证件号码获取用户信息
   */
  DubboResult<User> getUserByIdcard(UserTypeEnum userType, String idcard);

  /**
   * 增加用户,根据证件号码判断是否重复，没有新增，存在更新
   */
  DubboResult<User> addUser(User user);

  /**
   * 获取唯一用户
   */
  User getUniqueUser(String userType, String phone, String userName) throws AppException;

  DubboResult deleteUser(Long userId);

  DubboResult enabledUser(UserEnabledRequestDTO userEnabledRequestDTO);

  DubboResult updatePassword(UserPasswordRequestDTO userPasswordRequestDTO);

  Map getPersonType();


  /**
   * 查询角色详情(包含对应的区域信息)
   *
   * @param userId 用户id 必传
   * @param menuId 菜单id 非必传 (若不传则查询改用户的所有角色,若传则查询该用户拥有该菜单的角色)
   */
  List<UserRoleRelationDTO> getUserRoleRelationDTO(Long userId, Long menuId);

  DubboResult addUserInfo(UserAddRequestDTO userAddRequestDTO);

  DubboResult updateUserInfo(UserUpdateRequestDTO userAddRequestDTO);

  DubboResult searchUserInfo(UserSearchRequestDTO userSearchRequestDTO);

  List<RoleOrgResponseDTO> getOrgList(RoleOrgRequestDTO roleOrgRequestDTO);

  List<RoleDeptResponseDTO> getDeptList(Long id);

  UserAddRequestDTO getUserInfo(Long id);

  /**
   * 获取用户所有机构信息（包括机构和组织机构）
   */
  DubboResult<ArrayList<MechanismAndOrgResponseDTO>> getUserOrgAndMech(Long userId, String type);

  /**
   * 根据机构ID停用、启用用户
   */
  DubboResult stopOrStartByMechanism(Long mechanismId, JudgeEnum judgeEnum);

  /**
   * 停用部门下的人员账号
   */
  DubboResult stopOrStartByDepartments(List<Long> departmentIds,
      JudgeEnum judgeEnum);

  /**
   *
   */
  DubboResult delOrRestoreByDepartments(List<Long> departmentIds,
      JudgeEnum judgeEnum);

  DubboResult recordLoginInfo(String userName, String userType);

  DubboResult<PageInfo<User>>  listEncodeUserInfo(Integer pageNum, Integer pageSize);

  DubboResult<PageInfo<User>>  listUserInfo(Integer pageNum, Integer pageSize);

  void updateUserInfo(User user);

  DubboResult<LoginInfoResponseDTO> userLoginByUkey(String ukey);
}
