package com.beiming.nonlitigation.business.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.nonlitigation.business.domain.FileInfo;
import com.beiming.nonlitigation.business.domain.LawCaseEvaluate;
import com.beiming.nonlitigation.business.requestdto.CaseRequestDTO;
import com.beiming.nonlitigation.business.requestdto.PeopleMediateRequestDTO;
import com.beiming.nonlitigation.business.responsedto.CaseInfoResponseDTO;
import com.beiming.nonlitigation.business.responsedto.OdrSaveCaseResponseDTO;
import com.github.pagehelper.PageInfo;

/**
 * @author jiangfan
 * @date 2021/05/10
 */
public interface WxCaseServiceApi {

  DubboResult<OdrSaveCaseResponseDTO> odrAddCase(PeopleMediateRequestDTO peopleMediateRequestDto, String toString, String userId, String userName);

  DubboResult<PageInfo<CaseInfoResponseDTO>> getCaseList(CaseRequestDTO caseRequestDTO, String userId);

  DubboResult upload(FileInfo fileInfo, String currentUserId);

  DubboResult deleteFile(Long id, String currentUserId);

  DubboResult processDetail(Long caseId, String currentUserId);

  DubboResult insertEvaluate(LawCaseEvaluate evaluate);

  DubboResult evaluateList(Long caseId, String currentUserId);

  DubboResult isEvaluate(Long caseId, String createUser);

  DubboResult getByCaseId(Long caseId, String currentUserId);

  DubboResult evaluate(Long caseId, String createUser);
}
