package com.beiming.normandy.event.api;

import com.beiming.framework.config.FeignConfig;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.normandy.event.dto.MediationCaseBaseDTO;
import com.beiming.normandy.event.dto.requestdto.CaseCountReqDTO;
import com.beiming.normandy.event.dto.requestdto.CaseListZZReqDTO;
import com.beiming.normandy.event.dto.requestdto.MediationInfoReqDTO;
import com.beiming.normandy.event.dto.responsedto.CaseCountCountResDTO;
import com.beiming.normandy.event.dto.responsedto.CaseListZZResDTO;
import com.beiming.normandy.event.dto.responsedto.CaseProtocolPersonnelResDTO;
import com.beiming.normandy.event.dto.responsedto.MediationCountResDTO;
import com.beiming.normandy.event.dto.responsedto.MediationInfoResDTO;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "normandy-event", path = "/lawCaseApi", configuration = FeignConfig.class, contextId = "LawCaseApi")
public interface LawCaseApi {

  @RequestMapping(value = "getExistCaseByMediatorIds", method = {RequestMethod.POST})
  DubboResult<String> getExistCaseByMediatorIds(@RequestBody List<Long> mediatorIds);

  @RequestMapping(value = "countByProcDefId", method = {RequestMethod.POST})
  DubboResult<Integer> countByProcDefId(@RequestParam("procDefId") String procDefId);

  @RequestMapping(value = "selectLawCase", method = {RequestMethod.POST})
  DubboResult<MediationCaseBaseDTO> selectLawCase(@RequestParam("lawCaseId") Long lawCaseId);

  /**
   * 根据机构ID查询调解结束的案件
   */
  @RequestMapping(value = "getFinishCaseByOrgId", method = {RequestMethod.POST})
  DubboResult<PageInfo<CaseListZZResDTO>> getFinishCaseByOrgId(@Valid @RequestBody CaseListZZReqDTO request);

  /**
   * 根据useridList返回调解数量
   */
  @RequestMapping(value = "/countMediatorLawCaseNum", method = RequestMethod.POST)
  DubboResult<MediationCountResDTO> countMediatorLawCaseNum(@RequestBody ArrayList<Long> userIds);

  /**
   * 根据调解员id查询 某办理状态的案件
   */
  @RequestMapping(value = "/getCaseCountByCaseProgress", method = RequestMethod.POST)
  DubboResult<CaseCountCountResDTO> getCaseCountByCaseProgress(@Valid @RequestBody CaseCountReqDTO reqDTO);

  /**
   * 单个案件查询接口(为小程序待办事项设计)
   */
  @RequestMapping(value = "/getMediationInfoForPersonnalTask", method = RequestMethod.POST)
  DubboResult<MediationInfoResDTO> getMediationInfoForPersonnalTask(@RequestBody MediationInfoReqDTO reqDTO);

  /**
   * 通过案件id查询案件人员
   */
  @RequestMapping(value = "/getPersonList", method = RequestMethod.POST)
  DubboResult<ArrayList<CaseProtocolPersonnelResDTO>> getPersonList(@RequestParam("lawCaseId") Long lawCaseId);
}
